/*getElementByClassNameメソッドは、指定されたクラス名を持つ全ての要素をDOMの変更をリアルタイムで反映する、HTMLCollectionという動的なオブジェクトとして返す*/
/*querySelectorメソッドは、指定されたセレクター（ID、クラス、属性等CSSセレクターのどれでも指定可能）に一致する最初の要素を返す（返されるのは単一の要素）*/
const btn = document.querySelector('.btn-menu');
const nav = document.querySelector('.main-nav');

btn.addEventListener('click', () => {
    /*classListプロパティは、特定の要素のクラス属性のリストを返す。返されるリスト自体は読み取り専用だが、classListプロパティはaddメソッドやremoveメソッドなどの特別なメソッドを持っており、これらによってクラスの操作を行うことが出来る*/
    /*toggleメソッドでopen-menuクラスの追加・削除を切り替える*/
    nav.classList.toggle('open-menu');
    /*メニューのボタンをメニューの開閉に応じて変更をする*/
    if (btn.innerHTML === '<span></span><span></span><span></span>') {
        btn.innerHTML = '<span class="close"></span><span class="close"></span>';
    } else {
        btn.innerHTML = '<span></span><span></span><span></span>';
    }
});
